package ru.yandex.http.util;

import java.util.AbstractMap;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

public class DoubleFutureCallback<T, U> {
    private final Callback<T> first = new Callback<>();
    private final Callback<U> second = new Callback<>();
    private final FutureCallback<? super Map.Entry<T, U>> callback;
    private boolean done = false;

    public DoubleFutureCallback(
        final FutureCallback<? super Map.Entry<T, U>> callback)
    {
        this.callback = callback;
    }

    public FutureCallback<T> first() {
        return first;
    }

    public FutureCallback<U> second() {
        return second;
    }

    private class Callback<V> implements FutureCallback<V> {
        private boolean subrequestDone = false;
        private V result = null;

        @Override
        public void cancelled() {
            synchronized (DoubleFutureCallback.this) {
                if (done) {
                    return;
                }
                done = true;
            }
            callback.cancelled();
        }

        @Override
        public void failed(final Exception e) {
            synchronized (DoubleFutureCallback.this) {
                if (done) {
                    return;
                }
                done = true;
            }
            callback.failed(e);
        }

        @Override
        public void completed(final V result) {
            synchronized (DoubleFutureCallback.this) {
                if (done) {
                    return;
                }
                this.result = result;
                subrequestDone = true;
                if (first.subrequestDone == second.subrequestDone) {
                    done = true;
                } else {
                    return;
                }
            }
            callback.completed(
                new AbstractMap.SimpleImmutableEntry<>(
                    first.result,
                    second.result));
        }
    }
}

