package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

public class DuplexFutureCallback<T> implements FutureCallback<T> {
    private final FutureCallback<? super T> first;
    private final FutureCallback<? super T> second;

    public DuplexFutureCallback(
        final FutureCallback<? super T> first,
        final FutureCallback<? super T> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void cancelled() {
        first.cancelled();
        second.cancelled();
    }

    @Override
    public void completed(final T result) {
        first.completed(result);
        second.completed(result);
    }

    @Override
    public void failed(final Exception e) {
        first.failed(e);
        second.failed(e);
    }
}

