package ru.yandex.http.util;

import java.io.OutputStream;

import org.apache.http.Header;
import org.apache.http.HttpEntity;

import ru.yandex.io.EmptyInputStream;

public class EmptyHttpEntity implements HttpEntity {
    protected EmptyHttpEntity() {
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    @Override
    public Header getContentType() {
        return null;
    }

    @Override
    public Header getContentEncoding() {
        return null;
    }

    @Override
    public EmptyInputStream getContent() {
        return EmptyInputStream.INSTANCE;
    }

    @Override
    public void writeTo(final OutputStream out) {
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @SuppressWarnings("deprecation")
    @Override
    public void consumeContent() {
    }
}

