package ru.yandex.http.util;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.http.concurrent.Cancellable;
import org.apache.http.concurrent.FutureCallback;

public class ExecutorFutureCallback<T> extends FilterFutureCallback<T> {
    private final CancellationSubscriber cancellationSubscriber;
    private final Executor executor;

    public ExecutorFutureCallback(
        final FutureCallback<? super T> callback,
        final CancellationSubscriber cancellationSubscriber,
        final Executor executor)
    {
        super(callback);
        this.cancellationSubscriber = cancellationSubscriber;
        this.executor = executor;
    }

    @Override
    public void completed(T result) {
        try {
            DelegatedTask<T> task = new DelegatedTask<>(callback, result);
            cancellationSubscriber.subscribeForCancellation(task);
            executor.execute(task);
        } catch (RuntimeException e) {
            callback.failed(e);
        }
    }

    private static class DelegatedTask<T>
        extends AtomicBoolean
        implements Cancellable, Runnable
    {
        private static final long serialVersionUID = 0L;

        private final FutureCallback<? super T> callback;
        private final T result;

        DelegatedTask(
            final FutureCallback<? super T> callback,
            final T result)
        {
            this.callback = callback;
            this.result = result;
        }

        @Override
        public boolean cancel() {
            return compareAndSet(false, true);
        }

        @Override
        public void run() {
            if (get()) {
                callback.cancelled();
            } else {
                callback.completed(result);
            }
        }
    }
}
