package ru.yandex.http.util;

import java.util.function.Supplier;

import org.apache.http.protocol.HttpContext;

public class FillingHttpContextSupplier<T extends HttpContext>
    implements Supplier<T>
{
    private final Supplier<? extends T> supplier;
    private final String name;
    private final Object value;

    public FillingHttpContextSupplier(
        final Supplier<? extends T> supplier,
        final String name,
        final Object value)
    {
        this.supplier = supplier;
        this.name = name;
        this.value = value;
    }

    @Override
    public T get() {
        T t = supplier.get();
        t.setAttribute(name, value);
        return t;
    }
}

