package ru.yandex.http.util;

import java.util.concurrent.Future;

import org.apache.http.concurrent.Cancellable;

public class FilterCancellationSubscriber implements CancellationSubscriber {
    protected final CancellationSubscriber subscriber;

    public FilterCancellationSubscriber(
        final CancellationSubscriber subscriber)
    {
        this.subscriber = subscriber;
    }

    @Override
    public boolean cancelled() {
        return subscriber.cancelled();
    }

    @Override
    public void subscribeForCancellation(final Cancellable callback) {
        subscriber.subscribeForCancellation(callback);
    }

    @Override
    public void subscribeForCancellation(final Future<?> callback) {
        subscriber.subscribeForCancellation(callback);
    }

    @Override
    public void unsubscribeFromCancellation(final Cancellable callback) {
        subscriber.unsubscribeFromCancellation(callback);
    }

    @Override
    public void unsubscribeFromCancellation(final Future<?> callback) {
        subscriber.unsubscribeFromCancellation(callback);
    }
}

