package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

public class FutureCallbackChain<T> implements FutureCallback<T> {
    private FutureCallback<? super T> callback;
    private boolean completed = false;

    public FutureCallbackChain(final FutureCallback<? super T> callback) {
        this.callback = callback;
    }

    public synchronized void addFirst(
        final FutureCallback<? super T> callback)
    {
        this.callback = new DuplexFutureCallback<>(callback, this.callback);
    }

    private synchronized FutureCallback<? super T> callback() {
        if (completed) {
            return EmptyFutureCallback.instance();
        } else {
            completed = true;
            return callback;
        }
    }

    @Override
    public void cancelled() {
        callback().cancelled();
    }

    @Override
    public void completed(final T result) {
        callback().completed(result);
    }

    @Override
    public void failed(final Exception e) {
        callback().failed(e);
    }
}

