package ru.yandex.http.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.entity.HttpEntityWrapper;

import ru.yandex.compress.Deflater;
import ru.yandex.compress.GzipOutputStream;

public class GzipCompressingEntity extends HttpEntityWrapper {
    private static final Header CONTENT_ENCODING =
        HeaderUtils.createHeader(HttpHeaders.CONTENT_ENCODING, "gzip");

    private final int bufferSize;

    public GzipCompressingEntity(
        final HttpEntity entity,
        final int bufferSize)
    {
        super(entity);
        this.bufferSize = bufferSize;
    }

    @Override
    public Header getContentEncoding() {
        return CONTENT_ENCODING;
    }

    @Override
    public long getContentLength() {
        return -1;
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public InputStream getContent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        OutputStream gzip = new BufferedOutputStream(
            new GzipOutputStream(out, bufferSize, false, Deflater.BEST_SPEED),
            bufferSize);
        wrappedEntity.writeTo(gzip);
        gzip.close();
    }
}

