package ru.yandex.http.util;

import java.util.Objects;

import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

public final class HeaderUtils {
    private HeaderUtils() {
    }

    // FormattedHeader is more efficient for socket writing than BasicHeader
    public static FormattedHeader createHeader(
        final String name,
        final String value)
    {
        return new BasicFormattedHeader(name, value);
    }

    public static BufferedHeader createHeader(final String header) {
        CharArrayBuffer buffer = new CharArrayBuffer(header.length());
        buffer.append(header);
        return new BufferedHeader(buffer);
    }

    public static String value(final Header header) {
        return value(header, null);
    }

    public static String value(
        final Header header,
        final String defaultValue)
    {
        if (header == null) {
            return defaultValue;
        } else {
            return Objects.toString(header.getValue(), defaultValue);
        }
    }
}

