package ru.yandex.http.util;

import java.util.Iterator;

import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpMessage;

import ru.yandex.parser.string.ValuesStorage;

public class HeadersParser implements ValuesStorage<BadRequestException> {
    private final HttpMessage message;

    public HeadersParser(final HttpMessage message) {
        this.message = message;
    }

    @Override
    public BadRequestException parameterNotSetException(final String name) {
        return new BadRequestException("Header " + name + " is not set");
    }

    @Override
    public BadRequestException parseFailedException(
        final String name,
        final String value,
        final Throwable cause)
    {
        return new BadRequestException(
            "Failed to parse header " + name + " with value '" + value + '\'',
            cause);
    }

    @Override
    public String getOrNull(final String name) {
        return HeaderUtils.value(message.getFirstHeader(name));
    }

    @Override
    public String getLastOrNull(final String name) {
        return HeaderUtils.value(message.getLastHeader(name));
    }

    @Override
    public Iterator<String> getAllOrNull(final String name) {
        if (message.containsHeader(name)) {
            return new HeaderIteratorAdapter(message.headerIterator(name));
        } else {
            return null;
        }
    }

    public Header getHeader(final String name) throws BadRequestException {
        Header header = message.getFirstHeader(name);
        if (header == null) {
            throw parameterNotSetException(name);
        } else {
            return header;
        }
    }

    private static class HeaderIteratorAdapter implements Iterator<String> {
        private final HeaderIterator iter;

        HeaderIteratorAdapter(final HeaderIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return iter.hasNext();
        }

        @Override
        public String next() {
            return HeaderUtils.value(iter.nextHeader());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

