package ru.yandex.http.util;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public enum HeadfulResponseContent implements HttpResponseInterceptor {
    INSTANCE;

    private static final Header CONTENT_LENGTH_0 =
        HeaderUtils.createHeader(HTTP.CONTENT_LEN, "0");
    private static final Header CHUNKED_ENCODING = HeaderUtils.createHeader(
        HTTP.TRANSFER_ENCODING,
        HTTP.CHUNK_CODING);

    private static void addHeader(
        final HttpResponse response,
        final Header header)
    {
        if (header != null) {
            response.addHeader(header);
        }
    }

    @Override
    public void process(final HttpResponse response, final HttpContext context)
        throws HttpException, IOException
    {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            response.addHeader(CONTENT_LENGTH_0);
        } else {
            long len = entity.getContentLength();
            if (len == 0L) {
                response.addHeader(CONTENT_LENGTH_0);
            } else {
                if (entity.isChunked()) {
                    response.addHeader(CHUNKED_ENCODING);
                }
                if (len > 0L) {
                    response.addHeader(
                        HeaderUtils.createHeader(
                            HTTP.CONTENT_LEN,
                            Long.toString(len)));
                }
                addHeader(response, entity.getContentType());
                addHeader(response, entity.getContentEncoding());
                HttpRequest request = (HttpRequest) context.getAttribute(
                    HttpCoreContext.HTTP_REQUEST);
                if (request != null) {
                    if (request.getRequestLine().getMethod().equals("HEAD")) {
                        response.setEntity(null);
                        CharsetUtils.consume(entity);
                    }
                }
            }
        }
    }
}

