package ru.yandex.http.util;

import java.io.IOException;
import java.net.SocketTimeoutException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;

public final class HttpExceptionConverter {
    private HttpExceptionConverter() {
    }

    // CSOFF: ReturnCount
    public static HttpException toHttpException(final Throwable t) {
        if (t instanceof HttpException) {
            return (HttpException) t;
        } else if (t instanceof SocketTimeoutException) {
            return new GatewayTimeoutException();
        } else {
            return new BadGatewayException(t);
        }
    }

    public static HttpException toHttpException(
        final Object request,
        final Throwable t)
    {
        if (t instanceof HttpException) {
            return (HttpException) t;
        } else if (t instanceof SocketTimeoutException) {
            return new GatewayTimeoutException(request.toString());
        } else {
            return new BadGatewayException(request.toString(), t);
        }
    }
    // CSON: ReturnCount

    public static HttpException toHttpException(
        final Object request,
        final HttpResponse response)
    {
        HttpException e;
        try {
            e = new BadResponseException(request, response);
        } catch (IOException ex) {
            e = toHttpException(request, ex);
        } catch (HttpException ex) {
            e = ex;
        }
        return e;
    }
}

