package ru.yandex.http.util;

import java.util.function.BiConsumer;

import org.apache.http.HttpHost;

public enum HttpHostAppender implements BiConsumer<StringBuilder, HttpHost> {
    INSTANCE;

    public static void appendTo(final StringBuilder sb, final HttpHost host) {
        sb.append(host.getSchemeName());
        sb.append("://");
        sb.append(host.getHostName());
        int port = host.getPort();
        if (port != -1) {
            sb.append(':');
            sb.append(port);
        }
    }

    @Override
    public void accept(final StringBuilder sb, final HttpHost host) {
        appendTo(sb, host);
    }
}

