package ru.yandex.http.util;

import java.util.Comparator;

import org.apache.http.HttpHost;

// Support order, but for the performance sake compares port, then hostname,
// then scheme
public enum HttpHostComparator implements Comparator<HttpHost> {
    INSTANCE;

    @Override
    public int compare(final HttpHost lhs, final HttpHost rhs) {
        int cmp = Integer.compare(lhs.getPort(), rhs.getPort());
        if (cmp == 0) {
            cmp = lhs.getHostName().compareTo(rhs.getHostName());
            if (cmp == 0) {
                cmp = lhs.getSchemeName().compareTo(rhs.getSchemeName());
            }
        }
        return cmp;
    }
}

