package ru.yandex.http.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

import org.apache.http.HttpHost;

import ru.yandex.function.GenericFunction;

public enum HttpHostParser
    implements GenericFunction<String, HttpHost, MalformedURLException>
{
    INSTANCE;

    // CSOFF: FinalParameters
    @Override
    public HttpHost apply(String value) throws MalformedURLException {
        if (value.indexOf("://") == -1) {
            value = "http://" + value;
        }
        URL url = new URL(value);
        String scheme = url.getProtocol().toLowerCase(Locale.ENGLISH);
        String host = url.getHost().toLowerCase(Locale.ENGLISH);
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            throw new MalformedURLException(
                "Only 'http' and 'https' protocols supported");
        }
        if (host.isEmpty()) {
            throw new MalformedURLException("Empty host are not allowed");
        }
        if (port == -1) {
            throw new MalformedURLException("Can't determine port");
        }
        if (url.getUserInfo() != null && !url.getUserInfo().isEmpty()) {
            throw new MalformedURLException(
                "User credentials is not yet supported");
        }
        if (!url.getPath().replaceAll("/", "").isEmpty()) {
            throw new MalformedURLException(
                "Path is ignored, please, leave it empty");
        }
        if (url.getQuery() != null) {
            throw new MalformedURLException("Query is not allowed");
        }
        if (url.getRef() != null) {
            throw new MalformedURLException("Fragment is not allowed");
        }
        return new HttpHost(host, port, scheme);
    }
    // CSON: FinalParameters
}

