package ru.yandex.http.util;

import java.util.function.IntPredicate;

import org.apache.http.HttpStatus;

public final class HttpStatusPredicates {
    public static final IntPredicate OK = x -> x == HttpStatus.SC_OK;
    public static final IntPredicate ANY_GOOD =
        x -> x < HttpStatus.SC_BAD_REQUEST;
    public static final IntPredicate NON_FATAL =
        x -> !ServerErrorStatusPredicate.INSTANCE.test(x);
    public static final IntPredicate NON_PROTO_FATAL =
        x -> x <= YandexHttpStatus.SC_INTERNAL_SERVER_ERROR;

    private HttpStatusPredicates() {
    }
}

