package ru.yandex.http.util;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.http.concurrent.FutureCallback;

public class IdempotentFutureCallback<T> implements FutureCallback<T> {
    protected final FutureCallback<? super T> callback;
    protected final AtomicBoolean completed;

    public IdempotentFutureCallback(final FutureCallback<? super T> callback) {
        this(callback, new AtomicBoolean());
    }

    public IdempotentFutureCallback(
        final FutureCallback<? super T> callback,
        final AtomicBoolean completed)
    {
        this.callback = callback;
        this.completed = completed;
    }

    private FutureCallback<? super T> callback() {
        if (completed.compareAndSet(false, true)) {
            return callback;
        } else {
            return EmptyFutureCallback.instance();
        }
    }

    @Override
    public void cancelled() {
        callback().cancelled();
    }

    @Override
    public void completed(final T result) {
        callback().completed(result);
    }

    @Override
    public void failed(final Exception e) {
        callback().failed(e);
    }
}

