package ru.yandex.http.util;

import org.apache.http.HttpStatus;

public class InsufficientStorageException extends ServerException {
    public static final long serialVersionUID = 0;

    public InsufficientStorageException() {
        super(HttpStatus.SC_INSUFFICIENT_STORAGE);
    }

    public InsufficientStorageException(final Throwable t) {
        super(HttpStatus.SC_INSUFFICIENT_STORAGE, t);
    }

    public InsufficientStorageException(final String message) {
        super(HttpStatus.SC_INSUFFICIENT_STORAGE, message);
    }

    public InsufficientStorageException(
        final String message,
        final Throwable t)
    {
        super(HttpStatus.SC_INSUFFICIENT_STORAGE, message, t);
    }
}

