package ru.yandex.http.util;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.util.timesource.TimeSource;

public class LoggingFutureCallback<T> implements FutureCallback<T> {
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private final FutureCallback<? super T> callback;
    private final Logger logger;

    public LoggingFutureCallback(
        final FutureCallback<? super T> callback,
        final Logger logger)
    {
        this.callback = callback;
        this.logger = logger;
    }

    @Override
    public void cancelled() {
        logger.warning(
            "Request cancelled after "
            + (TimeSource.INSTANCE.currentTimeMillis() - start)
            + " ms");
        callback.cancelled();
    }

    @Override
    public void completed(final T result) {
        logger.fine(
            "Request completed after "
            + (TimeSource.INSTANCE.currentTimeMillis() - start)
            + " ms");
        callback.completed(result);
    }

    @Override
    public void failed(final Exception e) {
        logger.log(
            Level.WARNING,
            "Request failed after "
            + (TimeSource.INSTANCE.currentTimeMillis() - start)
            + " ms",
            e);
        callback.failed(e);
    }
}

