package ru.yandex.http.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.LazyList;

public class MultiFutureCallback<T> {
    private final List<Callback<T>> callbacks = new ArrayList<>();
    private final FutureCallback<? super List<T>> callback;
    private int onAir = 0;
    private boolean allSent = false;
    private boolean done = false;

    public MultiFutureCallback(
        final FutureCallback<? super List<T>> callback)
    {
        this.callback = callback;
    }

    public FutureCallback<T> newCallback() {
        Callback<T> callback = new Callback<>();
        callbacks.add(callback);
        synchronized (this) {
            ++onAir;
        }
        return callback;
    }

    public void done() {
        synchronized (this) {
            if (done) {
                return;
            }
            if (onAir == 0) {
                done = true;
            } else {
                allSent = true;
                return;
            }
        }
        completed();
    }

    private void completed() {
        callback.completed(new LazyList<>(callbacks, t -> t.result));
    }

    public void cancelled() {
        synchronized (this) {
            if (done) {
                return;
            }
            done = true;
        }
        callback.cancelled();
    }

    public void failed(final Exception e) {
        synchronized (this) {
            if (done) {
                return;
            }
            done = true;
        }
        callback.failed(e);
    }

    private class Callback<V> implements FutureCallback<V> {
        private boolean subrequestDone = false;
        private V result = null;

        @Override
        public void cancelled() {
            synchronized (MultiFutureCallback.this) {
                if (done || subrequestDone) {
                    return;
                }
                done = true;
            }
            callback.cancelled();
        }

        @Override
        public void failed(final Exception e) {
            synchronized (MultiFutureCallback.this) {
                if (done || subrequestDone) {
                    return;
                }
                done = true;
            }
            callback.failed(e);
        }

        @Override
        public void completed(final V result) {
            synchronized (MultiFutureCallback.this) {
                if (done || subrequestDone) {
                    return;
                }
                this.result = result;
                subrequestDone = true;
                if (--onAir == 0 && allSent) {
                    done = true;
                } else {
                    return;
                }
            }
            MultiFutureCallback.this.completed();
        }
    }
}

