package ru.yandex.http.util;

import java.util.AbstractMap;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

public class PayloadFutureCallback<T, U>
    extends AbstractFilterFutureCallback<U, Map.Entry<T, U>>
{
    private final T payload;

    public PayloadFutureCallback(
        final T payload,
        final FutureCallback<? super Map.Entry<T, U>> callback)
    {
        super(callback);
        this.payload = payload;
    }

    @Override
    public void completed(final U result) {
        callback.completed(
            new AbstractMap.SimpleImmutableEntry<>(payload, result));
    }
}

