package ru.yandex.http.util;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public abstract class ResponseContentEncodingBase
    implements HttpResponseInterceptor
{
    public static final String NO_COMPRESS =
        "ru.yandex.http.server.sync.no-compress";
    public static final String FORCE_COMPRESS =
        "ru.yandex.http.server.sync.force-compress";

    private static final String IDENTITY = "identity";
    private static final long MIN_CONTENT_LENGTH = 1200L;

    protected final boolean gzip;
    protected final int bufferSize;

    protected ResponseContentEncodingBase(
        final boolean gzip,
        final int bufferSize)
    {
        this.gzip = gzip;
        this.bufferSize = bufferSize;
    }

    protected boolean gzip(
        final HttpResponse response,
        final HttpContext context)
    {
        HttpEntity entity = response.getEntity();
        if (entity != null
            && ((gzip
                 && context.getAttribute(NO_COMPRESS) == null
                    && response.getProtocolVersion().greaterEquals(
                        HttpVersion.HTTP_1_1))
                || context.getAttribute(FORCE_COMPRESS) != null)
            && HeaderUtils.value(entity.getContentEncoding(), IDENTITY)
                .equals(IDENTITY))
        {
            long contentLength = entity.getContentLength();
            if (contentLength < 0L || contentLength >= MIN_CONTENT_LENGTH) {
                HttpRequest request = (HttpRequest) context.getAttribute(
                    HttpCoreContext.HTTP_REQUEST);
                if (request != null) {
                    Header acceptEncoding =
                        request.getFirstHeader(HttpHeaders.ACCEPT_ENCODING);
                    if (acceptEncoding != null) {
                        try {
                            HeaderElement[] elements =
                                BasicHeaderValueParser
                                    .parseElements(
                                        acceptEncoding.getValue(),
                                        null);
                            for (int i = 0; i < elements.length; ++i) {
                                if ("gzip".equals(elements[i].getName())) {
                                    return true;
                                }
                            }
                        } catch (RuntimeException e) { // NPE or ParseException
                        }
                    }
                }
            }
        }
        return false;
    }
}

