package ru.yandex.http.util;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public enum ResponseXRequestId implements HttpResponseInterceptor {
    INSTANCE;

    @Override
    public void process(
        final HttpResponse response,
        final HttpContext context)
    {
        // Check that header is not set explicitly
        Header explicit = response.getFirstHeader(YandexHeaders.X_REQUEST_ID);
        if (explicit == null) {
            HttpRequest request = (HttpRequest) context.getAttribute(
                HttpCoreContext.HTTP_REQUEST);
            if (request != null) {
                Header incomingXRequestId =
                    request.getFirstHeader(YandexHeaders.X_REQUEST_ID);
                if (incomingXRequestId != null) {
                    response.setHeader(incomingXRequestId);
                }
            }
        }
    }
}

