package ru.yandex.http.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

public class SequentialCompleteMultiFutureCallback<T> {
    private final List<FutureCallback<T>> callbacks;
    private final FutureCallback<List<T>> callback;
    private final AtomicInteger cbGetCnt = new AtomicInteger(0);
    private final SequentialCompleteMultiFutureContext<T> context;
    private final Logger logger;

    @SuppressWarnings("unchecked")
    public SequentialCompleteMultiFutureCallback(
        final FutureCallback<List<T>> callback,
        final Logger logger,
        final int size)
    {
        this.logger = logger;
        List<FutureCallback<T>> callbacks = new ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            callbacks.add(new Callback(i));
        }

        this.callbacks = callbacks;
        this.callback = callback;
        this.context = new SequentialCompleteMultiFutureContext<>(size);
    }

    public FutureCallback<T> next() {
        return callbacks.get(cbGetCnt.getAndIncrement());
    }


    private class Callback implements FutureCallback<T> {
        private final int index;

        public Callback(final int index) {
            this.index = index;
        }

        public int index() {
            return index;
        }

        @Override
        public void cancelled() {
            callback.cancelled();
        }

        @Override
        public void failed(final Exception e) {
            List<T> ready = context.failed(index);
            if (ready != null) {
                logger.fine(
                    "Ordered failed " + index + " " + ready.size());
                if (ready.size() > 1) {
                    callback.completed(ready);
                }

                callback.failed(e);
            }
        }

        @Override
        public void completed(final T result) {
            List<T> ready = context.completed(index, result);
            if (ready != null) {
                logger.fine(
                    "Ordered completed " + index + " " + ready.size());
                callback.completed(ready);
            } else {
                logger.fine(
                    "Ordered completed " + index + " waiting other");
            }
        }
    }
}
