package ru.yandex.http.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SequentialCompleteMultiFutureContext<T> {
    public enum Status {
        RUNNING,
        COMPLETED,
        FAILED
    }

    private final List<T> results;
    private final Status[] status;
    private int sequenceSize = 0;

    public SequentialCompleteMultiFutureContext(final int size) {
        this.results = new ArrayList<>(Collections.nCopies(size, null));
        this.status = new Status[size];
        for (int i = 0; i < size; i++) {
            this.status[i] = Status.RUNNING;
        }
    }

    public synchronized List<T> completed(final int index, final T result) {
        this.results.set(index, result);
        this.status[index] = Status.COMPLETED;

        if (sequenceSize == index) {
            return resultSequence();
        }

        return null;
    }

    public synchronized List<T> failed(final int index) {
        this.results.set(index, null);
        this.status[index] = Status.FAILED;

        if (sequenceSize == index) {
            return resultSequence();
        }

        return null;
    }

    public synchronized T result(final int index) {
        return results.get(index);
    }

    private synchronized List<T> resultSequence() {
        int newSeqSize = sequenceSize;
        for (int i = sequenceSize; i < status.length; i++) {
            if (status[i] != Status.COMPLETED) {
                break;
            }

            newSeqSize = i + 1;
        }

        sequenceSize = newSeqSize;
        return results.subList(0, sequenceSize);
    }

}
