package ru.yandex.http.util;

import java.util.function.IntPredicate;

public class ServerErrorStatusPredicate implements IntPredicate {
    public static final ServerErrorStatusPredicate INSTANCE =
        new ServerErrorStatusPredicate();

    protected ServerErrorStatusPredicate() {
    }

    @Override
    public boolean test(final int status) {
        return status >= YandexHttpStatus.SC_INTERNAL_SERVER_ERROR
            && status != YandexHttpStatus.SC_NOT_IMPLEMENTED
            && status != YandexHttpStatus.SC_HTTP_VERSION_NOT_SUPPORTED
            && status != YandexHttpStatus.SC_BUSY;
    }
}

