package ru.yandex.http.util;

import java.util.Locale;

import org.apache.http.HttpException;

import ru.yandex.io.StringBuilderWriter;

public class ServerException extends HttpException {
    public static final long serialVersionUID = 0;

    private final int statusCode;
    private final String message;

    public ServerException(final int statusCode) {
        this(statusCode, (String) null);
    }

    public ServerException(final int statusCode, final Throwable t) {
        this.statusCode = statusCode;
        if (t == null) {
            message = null;
        } else {
            message = t.toString();
            initCause(t);
        }
    }

    public ServerException(final int statusCode, final String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public ServerException(
        final int statusCode,
        final String message,
        final Throwable t)
    {
        this.statusCode = statusCode;
        this.message = message;
        initCause(t);
    }

    public int statusCode() {
        return statusCode;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        getMessage(sb);
        return new String(sb);
    }

    public void getMessage(final StringBuilder sb) {
        sb.append("HTTP/1.1 ");
        sb.append(statusCode);
        sb.append(' ');
        sb.append(
            YandexReasonPhraseCatalog.INSTANCE.getReason(
                statusCode,
                Locale.ENGLISH));
        if (message != null) {
            sb.append(':');
            sb.append(' ');
            sb.append(message);
        }
    }

    public String toStackTrace() {
        StringBuilderWriter sbw = new StringBuilderWriter();
        printStackTrace(sbw);
        return sbw.toString();
    }
}

