package ru.yandex.http.util;

import org.apache.http.HttpStatus;

public class ServiceUnavailableException extends ServerException {
    public static final long serialVersionUID = 0;

    public ServiceUnavailableException() {
        super(HttpStatus.SC_SERVICE_UNAVAILABLE);
    }

    public ServiceUnavailableException(final Throwable t) {
        super(HttpStatus.SC_SERVICE_UNAVAILABLE, t);
    }

    public ServiceUnavailableException(final String message) {
        super(HttpStatus.SC_SERVICE_UNAVAILABLE, message);
    }

    public ServiceUnavailableException(
        final String message,
        final Throwable t)
    {
        super(HttpStatus.SC_SERVICE_UNAVAILABLE, message, t);
    }
}

