package ru.yandex.http.util;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class StaticHeaders implements HttpResponseInterceptor {
    private final Header[] staticHeaders;

    public StaticHeaders(final Header... staticHeaders) {
        this.staticHeaders = staticHeaders;
    }

    @Override
    public void process(
        final HttpResponse response,
        final HttpContext context)
    {
        for (Header header: staticHeaders) {
            response.addHeader(header);
        }
    }
}

