package ru.yandex.http.util;

import java.util.IdentityHashMap;

import org.apache.http.protocol.HttpContext;

public class SynchronizedHttpContext
    extends IdentityHashMap<String, Object>
    implements HttpContext
{
    private static final long serialVersionUID = 0L;

    @Override
    public synchronized Object getAttribute(final String id) {
        return get(id);
    }

    @Override
    public synchronized void setAttribute(final String id, final Object obj) {
        put(id, obj);
    }

    @Override
    public synchronized Object removeAttribute(final String id) {
        return remove(id);
    }
}

