package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.LongPair;
import ru.yandex.util.timesource.TimeSource;

public class TimingFutureCallback<T>
    extends AbstractFilterFutureCallback<T, LongPair<T>>
{
    private final long start = TimeSource.INSTANCE.currentTimeMillis();

    public TimingFutureCallback(
        final FutureCallback<? super LongPair<T>> callback)
    {
        super(callback);
    }

    @Override
    public void completed(final T response) {
        callback.completed(
            new LongPair<>(
                TimeSource.INSTANCE.currentTimeMillis() - start,
                response));
    }
}

