package ru.yandex.http.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.http.HttpHeaders;
import org.joda.time.format.DateTimeFormat;

public final class YandexHeaders {
    public static final String CHECK_DUPLICATE = "Check-Duplicate";
    public static final String CHECK_MEM_DUPLICATE = "Check-Mem-Duplicate";
    public static final String FAIL_ON_DUPLICATE = "Fail-On-Duplicate";
    public static final String FAIL_ON_MEM_DUPLICATE = "Fail-On-Mem-Duplicate";
    public static final String HOSTNAME = "Hostname";
    public static final String LOCKID = "lockid";
    public static final String MAX_OPERATION_ID = "Max-Operation-Id";
    public static final String PGSHARD = "Pg-Shard";
    public static final String PRODUCER_NAME = "producer-name";
    public static final String PRODUCER_POSITION = "producer-position";
    public static final String RETRY_COUNT = "retry-count";
    public static final String SERVICE = "service";
    public static final String SESSION_ID = "Session-ID";
    public static final String TICKET = "Ticket";
    public static final String URI = "URI";
    // Multipart submessage http method
    public static final String ZOO_HTTP_METHOD = "X-Zoo-Http-Method";
    public static final String ZOO_QUEUE = "ZooQueue";
    public static final String ZOO_QUEUE_ID = "ZooQueueId";
    public static final String ZOO_QUEUE_ID_TO_CHECK = "ZooQueueIdToCheck";
    public static final String ZOO_SHARD_ID = "ZooShardId";
    public static final String ZOO_HASH = "ZooHash";
    public static final String ZOO_CTIME = "ZooCTime";
    public static final String ZOO_ATIME = "ZooATime";
    public static final String X_INDEX_OPERATION_QUEUE =
        "X-Index-Operation-Queue";
    public static final String X_INDEX_OPERATION_TIMESTAMP =
        "X-Index-Operation-Timestamp";
    public static final String X_REQUEST_ID = "X-Request-Id";
    public static final String X_REAL_IP = "X-Real-IP";
    public static final String X_FORWARDED_FOR_Y = "X-Forwarded-For-Y";
    public static final String X_YANDEX_WARNING = "X-Yandex-Warning";

    // experiments for user
    public static final String X_ENABLED_BOXES = "x-yandex-enabledexpboxes";
    public static final String X_BOXES = "x-yandex-expboxes";
    public static final String X_CLIENT_TYPE = "x-yandex-clienttype";
    public static final String X_PEACH_QUEUE = "X-Peach-Queue";
    public static final String X_FEAUTURE_PARAMS = "x-feature-params";

    // universal search proxy headers
    public static final String X_MINIMAL_POSITION = "X-Minimal-Position";
    public static final String X_SEARCH_PREFIX = "X-Search-Prefix";
    public static final String X_SEARCH_FAILOVER_DELAY =
        "X-Search-Failover-Delay";

    // TVM 2.0 service ticket header
    public static final String X_YA_SERVICE_TICKET = "X-Ya-Service-Ticket";
    public static final String X_YA_USER_TICKET = "X-Ya-User-Ticket";

    // ljinx headers
    public static final String X_CACHE_INVALIDATE = "X-Cache-Invalidate";
    public static final String X_CACHE_STATUS = "X-Cache-Status";
    public static final String X_CACHE_HIT_TYPE = "X-Cache-Hit-Type";
    public static final String X_LJINX_IGNORE_SIBLINGS =
        "X-Ljinx-Ignore-Siblings";

    // APE routing headers
    public static final String X_SRW_NAMESPACE = "X-Srw-Namespace";
    public static final String X_SRW_KEY_TYPE = "X-Srw-Key-Type";
    public static final String X_SRW_KEY = "X-Srw-Key";
    // TVM 2.0 unistorage service ticket header
    public static final String X_SRW_SERVICE_TICKET = "X-Srw-Service-Ticket";

    // This header is to be used as part of ljinx cache key
    public static final String X_YANDEX_QUEUE_MESSAGE_ID =
        "X-Yandex-Queue-Message-Id";

    public static final String BUILT_DATE;

    static {
        try {
            BUILT_DATE = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss")
                .print(YandexHeaders.class
                    .getResource("YandexHeaders.class")
                        .openConnection().getLastModified());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    // TVM 2.0 tickets and authorization headers
    public static final Set<String> DEFAULT_HIDDEN_HEADERS;

    static {
        Set<String> hiddenHeaders =
            new TreeSet<>(String.CASE_INSENSITIVE_ORDER);
        hiddenHeaders.add(HttpHeaders.AUTHORIZATION);
        hiddenHeaders.add(YandexHeaders.X_YA_SERVICE_TICKET);
        hiddenHeaders.add(YandexHeaders.X_YA_USER_TICKET);
        hiddenHeaders.add(YandexHeaders.X_SRW_SERVICE_TICKET);
        hiddenHeaders.add("ticket");
        DEFAULT_HIDDEN_HEADERS = Collections.unmodifiableSet(hiddenHeaders);
    }

    public static final List<String> ZOO_HEADERS =
        Collections.unmodifiableList(
            Arrays.asList(
                ZOO_QUEUE,
                ZOO_QUEUE_ID,
                ZOO_SHARD_ID,
                ZOO_HASH,
                ZOO_CTIME,
                ZOO_ATIME));

    private YandexHeaders() {
    }
}

