package ru.yandex.http.util;

import java.util.Locale;

import org.apache.http.HttpStatus;
import org.apache.http.impl.EnglishReasonPhraseCatalog;

public class YandexReasonPhraseCatalog extends EnglishReasonPhraseCatalog {
    public static final YandexReasonPhraseCatalog INSTANCE =
        new YandexReasonPhraseCatalog();

    protected YandexReasonPhraseCatalog() {
    }

    @Override
    public String getReason(final int status, final Locale loc) {
        String reason;
        switch (status) {
            case HttpStatus.SC_SERVICE_UNAVAILABLE:
                reason = "Mugcina vy chto ne vidite y nas obed";
                break;
            case YandexHttpStatus.SC_PRECONDITION_REQUIRED:
                reason = "Precondition Required";
                break;
            case YandexHttpStatus.SC_TOO_MANY_REQUESTS:
                reason = "Too Many Requests";
                break;
            case YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST:
                reason = "Client Closed Request";
                break;
            case YandexHttpStatus.SC_REQUESTS_LIMIT_REACHED:
                reason = "Maximum allowed parallel requests has been reached";
                break;
            case YandexHttpStatus.SC_BUSY:
                reason = "Busy";
                break;
            case YandexHttpStatus.SC_QUEUED:
                reason = "Queued";
                break;
            case YandexHttpStatus.SC_ENTITY_SEND_FAILED:
                reason = "Entity send failed";
                break;
            case YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST:
                reason = "Network read timeout error";
                break;
            default:
                reason = super.getReason(status, loc);
                break;
        }
        return reason;
    }
}

