package ru.yandex.http.util.nio.client;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.http.util.nio.client.pool.TimedConnection;
import ru.yandex.util.timesource.TimeSource;

public abstract class AbstractCompletedRequestInfo
    extends AbstractRequestInfo
{
    private static final DateTimeFormatter DATE_FORMATTER =
        DateTimeFormat.forPattern("HH:mm:ss.SSS");

    private final long endTime = TimeSource.INSTANCE.currentTimeMillis();
    private final long dnsTime;
    private final long poolTime;
    private final long connTime;

    protected AbstractCompletedRequestInfo(final RequestData requestData) {
        super(requestData);
        TimedConnection conn = requestData.connection();
        if (conn == null) {
            dnsTime = 0L;
            poolTime = 0L;
            connTime = 0L;
        } else {
            dnsTime = conn.dnsTime(requestData.startTime());
            poolTime = conn.poolTime();
            connTime = conn.connTime();
        }
    }

    protected void writeTiming(final StringBuilder sb) {
        long startTime = startTime();
        sb.append(endTime - startTime);
        sb.append(" ms (started ");
        DATE_FORMATTER.printTo(sb, startTime);
        sb.append(", dns ");
        sb.append(dnsTime());
        sb.append(", pool ");
        sb.append(poolTime());
        sb.append(" ms, connect ");
        sb.append(connTime());
        sb.append(" ms) with ");
    }

    @Override
    public long endTime() {
        return endTime;
    }

    @Override
    public long dnsTime() {
        return dnsTime;
    }

    @Override
    public long poolTime() {
        return poolTime;
    }

    @Override
    public long connTime() {
        return connTime;
    }
}

