package ru.yandex.http.util.nio.client;

import org.apache.http.conn.routing.HttpRoute;

import ru.yandex.http.util.nio.client.pool.TimedConnection;

public abstract class AbstractRequestInfo implements RequestInfo {
    protected final RequestData requestData;

    protected AbstractRequestInfo(final RequestData requestData) {
        this.requestData = requestData;
    }

    protected abstract void resultDetails(StringBuilder sb);

    @Override
    public HttpRoute route() {
        return requestData.route();
    }

    @Override
    public long startTime() {
        return requestData.startTime();
    }

    @Override
    public long dnsTime() {
        TimedConnection conn = requestData.connection();
        if (conn == null) {
            return 0L;
        } else {
            return conn.dnsTime(requestData.startTime());
        }
    }

    @Override
    public long poolTime() {
        TimedConnection conn = requestData.connection();
        if (conn == null) {
            return 0L;
        } else {
            return conn.poolTime();
        }
    }

    @Override
    public long connTime() {
        TimedConnection conn = requestData.connection();
        if (conn == null) {
            return 0L;
        } else {
            return conn.connTime();
        }
    }

    @Override
    public Object requestsGroup() {
        return requestData.requestsGroup();
    }

    @Override
    public void longResult(final StringBuilder sb) {
        sb.append("Request to ");
        BasicRequestsListener.appendRoute(sb, requestData.route());
        sb.append(':');
        sb.append(' ');
        sb.append(requestData.request());
        resultDetails(sb);
    }
}

