package ru.yandex.http.util.nio.client;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.RequestErrorType;

public class AnyOfFutureCallback<T> implements FutureCallback<T> {
    private final FutureCallback<? super T> callback;
    private final Function<? super Exception, RequestErrorType> errorClassifier;
    private final AtomicInteger requests;
    private Exception e = null;

    public AnyOfFutureCallback(
        final FutureCallback<? super T> callback,
        final Function<? super Exception, RequestErrorType> errorClassifier,
        final int requests)
    {
        this.callback = callback;
        this.errorClassifier = errorClassifier;
        this.requests = new AtomicInteger(requests);
    }

    @Override
    public void cancelled() {
        if (requests.decrementAndGet() == 0) {
            callback.cancelled();
        }
    }

    @Override
    public void completed(final T result) {
        if (requests.getAndSet(0) > 0) {
            callback.completed(result);
        }
    }

    @Override
    public void failed(final Exception e) {
        RequestErrorType errorType = errorClassifier.apply(e);
        if (errorType == RequestErrorType.NON_RETRIABLE) {
            if (requests.getAndSet(0) > 0) {
                callback.failed(e);
            }
        } else {
            Exception ex = null;
            synchronized (this) {
                if (this.e == null) {
                    this.e = e;
                } else {
                    this.e.addSuppressed(e);
                }
                if (requests.decrementAndGet() == 0) {
                    ex = this.e;
                    this.e = null;
                }
            }
            if (ex != null) {
                callback.failed(ex);
            }
        }
    }
}

