package ru.yandex.http.util.nio.client;

import java.util.function.Function;

import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.http.util.nio.client.pool.AsyncNHttpClientConnectionManager;

public class AsyncClient extends AbstractAsyncClient<AsyncClient> {
    public AsyncClient(
        final SharedConnectingIOReactor reactor,
        final ImmutableHttpTargetConfig backendConfig)
    {
        super(reactor, backendConfig);
    }

    public AsyncClient(
        final SharedConnectingIOReactor reactor,
        final ImmutableHttpTargetConfig backendConfig,
        final Function<? super Exception, RequestErrorType> errorClassifier)
    {
        super(reactor, backendConfig, errorClassifier);
    }

    public AsyncClient(
        final AsyncNHttpClientConnectionManager connManager,
        final ImmutableHttpTargetConfig backendConfig,
        final Function<? super Exception, RequestErrorType> errorClassifier)
    {
        super(connManager, backendConfig, errorClassifier);
    }

    protected AsyncClient(
        final CloseableHttpAsyncClient client,
        final AsyncClient sample)
    {
        super(client, sample);
    }

    @Override
    protected AsyncClient adjust(final CloseableHttpAsyncClient client) {
        return new AsyncClient(client, this);
    }
}

