package ru.yandex.http.util.nio.client;

import java.util.function.Function;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.RequestErrorType;

// Represents object that could create AsyncClient, register it for closing and
// will start it when server will start.
// Also, it will register client staters
public interface AsyncClientRegistrar {
    SharedConnectingIOReactor reactor();

    default AsyncClient client(
        final String name,
        final ImmutableHttpTargetConfig config)
    {
        return client(name, config, RequestErrorType.ERROR_CLASSIFIER);
    }

    AsyncClient client(
        String name,
        ImmutableHttpTargetConfig config,
        Function<? super Exception, RequestErrorType> errorClassifier);

    // Adds client to close chain and returns client with automatic tvm headers
    <T extends AbstractAsyncClient<T>> T registerClient(
        String name,
        T client,
        ImmutableHttpTargetConfig config);
}

