package ru.yandex.http.util.nio.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;

import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class AsyncGetURIRequestProducerSupplier
    implements Supplier<HttpAsyncRequestProducer>
{
    private final URI uri;

    public AsyncGetURIRequestProducerSupplier(final String uri)
        throws URISyntaxException
    {
        this(new URI(uri).parseServerAuthority());
    }

    public AsyncGetURIRequestProducerSupplier(final URI uri) {
        this.uri = uri;
    }

    @Override
    public HttpAsyncRequestProducer get() {
        return HttpAsyncMethods.createGet(uri);
    }
}

