package ru.yandex.http.util.nio.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.CharsetUtils;

public class AsyncPostURIRequestProducerSupplier
    implements Supplier<HttpAsyncRequestProducer>
{
    private final URI uri;
    private final byte[] rawContent;
    private final String stringContent;
    private final ContentType contentType;

    public AsyncPostURIRequestProducerSupplier(
        final String uri,
        final byte[] content,
        final ContentType contentType)
        throws URISyntaxException
    {
        this(new URI(uri).parseServerAuthority(), content, contentType);
    }

    public AsyncPostURIRequestProducerSupplier(
        final String uri,
        final String content,
        final ContentType contentType)
        throws URISyntaxException
    {
        this(new URI(uri).parseServerAuthority(), content, contentType);
    }

    public AsyncPostURIRequestProducerSupplier(
        final URI uri,
        final HttpEntity entity)
        throws IOException
    {
        this(uri, CharsetUtils.toByteArray(entity), ContentType.get(entity));
    }

    public AsyncPostURIRequestProducerSupplier(
        final URI uri,
        final byte[] content,
        final ContentType contentType)
    {
        this.uri = uri;
        this.rawContent = content;
        this.contentType = contentType;
        this.stringContent = null;
    }

    public AsyncPostURIRequestProducerSupplier(
        final URI uri,
        final String content,
        final ContentType contentType)
    {
        this.uri = uri;
        this.stringContent = content;
        this.contentType = contentType;
        this.rawContent = null;
    }

    private static byte[] convertString(final String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public HttpAsyncRequestProducer get() {
        if (rawContent != null) {
            return HttpAsyncMethods.createPost(uri, rawContent, contentType);
        } else {
            HttpAsyncRequestProducer producer;
            try {
                producer = HttpAsyncMethods.createPost(
                    uri,
                    stringContent,
                    contentType);
            } catch (UnsupportedEncodingException e) {
                producer = HttpAsyncMethods.createPost(
                    uri,
                    convertString(stringContent),
                    contentType);
            }
            return producer;
        }
    }
}
