package ru.yandex.http.util.nio.client;

import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class BasicRetryContext<T> implements RetryContext<T> {
    protected final ClientContext clientContext;
    private final RequestContext<T> requestContext;
    private final Supplier<? extends HttpAsyncRequestProducer>
        producerSupplier;
    private int ioRetries = 0;
    private int httpRetries = 0;

    public BasicRetryContext(
        final RequestContext<T> requestContext,
        final ClientContext clientContext,
        final Supplier<? extends HttpAsyncRequestProducer> producerSupplier)
    {
        this.requestContext = requestContext;
        this.clientContext = clientContext;
        this.producerSupplier = producerSupplier;
    }

    @Override
    public Future<T> sendRequest(final FutureCallback<T> callback) {
        return requestContext.sendRequest(
            producerSupplier.get(),
            requestContext.contextSupplier().get(),
            callback);
    }

    @Override
    public long nextRetryInterval(final Exception e) {
        long interval = -1L;
        switch (clientContext.detectErrorType(e)) {
            case IO:
                if (++ioRetries <= clientContext.ioRetries().count()) {
                    interval = clientContext.ioRetries().interval();
                }
                break;
            case HTTP:
                if (++httpRetries <= clientContext.httpRetries().count()) {
                    interval = clientContext.httpRetries().interval();
                }
                break;
            default:
                break;
        }
        return interval;
    }

    @Override
    public void scheduleRetry(final TimerTask task, final long delay) {
        clientContext.scheduleRetry(task, delay);
    }
}

