package ru.yandex.http.util.nio.client;

import java.util.function.Supplier;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class BasicRetryContextFactory implements RetryContextFactory {
    private final Supplier<? extends HttpAsyncRequestProducer>
        producerSupplier;

    public BasicRetryContextFactory(
        final Supplier<? extends HttpAsyncRequestProducer> producerSupplier)
    {
        this.producerSupplier = producerSupplier;
    }

    @Override
    public <T> BasicRetryContext<T> create(
        final RequestContext<T> requestContext,
        final ClientContext clientContext)
    {
        return new BasicRetryContext<>(
            requestContext,
            clientContext,
            producerSupplier);
    }
}

