package ru.yandex.http.util.nio.client;

import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.config.ImmutableRetriesConfig;
import ru.yandex.http.util.RequestErrorType;

public class ClientContext {
    private final Function<? super Exception, RequestErrorType>
        errorClassifier;
    private final Timer timer;
    private final ImmutableRetriesConfig ioRetries;
    private final ImmutableRetriesConfig httpRetries;

    public ClientContext(
        final Function<? super Exception, RequestErrorType> errorClassifier,
        final Timer timer,
        final ImmutableHttpTargetConfig backendConfig)
    {
        this.errorClassifier = errorClassifier;
        this.timer = timer;
        ioRetries = backendConfig.ioRetries();
        httpRetries = backendConfig.httpRetries();
    }

    public RequestErrorType detectErrorType(final Exception e) {
        return errorClassifier.apply(e);
    }

    public Function<? super Exception, RequestErrorType> errorClassifier() {
        return errorClassifier;
    }

    public ImmutableRetriesConfig ioRetries() {
        return ioRetries;
    }

    public ImmutableRetriesConfig httpRetries() {
        return httpRetries;
    }

    public void scheduleRetry(final TimerTask task, final long delay) {
        if (delay == 0L) {
            task.run();
        } else {
            try {
                timer.schedule(task, delay);
            } catch (RuntimeException e) {
                e.printStackTrace();
                task.run();
            }
        }
    }
}

