package ru.yandex.http.util.nio.client;

import java.util.TimerTask;
import java.util.concurrent.Future;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.CancelledFuture;

public class CompletionCheckingRetryContext<T> implements RetryContext<T> {
    private final RetryContext<T> context;
    // Used for completion checking
    private final Future<T> requestFuture;

    public CompletionCheckingRetryContext(
        final RetryContext<T> context,
        final Future<T> requestFuture)
    {
        this.context = context;
        this.requestFuture = requestFuture;
    }

    @Override
    public Future<T> sendRequest(final FutureCallback<T> callback) {
        if (requestFuture.isDone()) {
            callback.cancelled();
            return CancelledFuture.instance();
        } else {
            return context.sendRequest(callback);
        }
    }

    @Override
    public long nextRetryInterval(final Exception e) {
        if (requestFuture.isDone()) {
            return -1L;
        } else {
            return context.nextRetryInterval(e);
        }
    }

    @Override
    public void scheduleRetry(final TimerTask task, final long delay) {
        if (!requestFuture.isDone()) {
            context.scheduleRetry(task, delay);
        }
    }
}

