package ru.yandex.http.util.nio.client;

import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import org.apache.http.Header;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.HeaderAsyncRequestProducer;

public class CustomDynamicHeadersCloseableHttpClient
    extends FilterCloseableHttpAsyncClient {
    private final Supplier<List<Header>> headersSupplier;

    public CustomDynamicHeadersCloseableHttpClient(
        final CloseableHttpAsyncClient client,
        final Supplier<List<Header>> headersSupplier) {
        super(client);

        this.headersSupplier = headersSupplier;
    }

    @Override
    public <T> Future<T> execute(
        final HttpAsyncRequestProducer requestProducer,
        final HttpAsyncResponseConsumer<T> responseConsumer,
        final HttpContext context,
        final FutureCallback<T> callback) {
        return super.execute(
            new HeaderAsyncRequestProducer(
                requestProducer,
                headersSupplier.get()),
            responseConsumer,
            context,
            callback);
    }
}
