package ru.yandex.http.util.nio.client;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;

import org.apache.http.Header;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.HeaderAsyncRequestProducer;

public class CustomHeaderCloseableHttpAsyncClient
    extends FilterCloseableHttpAsyncClient
{
    private final List<Header> headers;

    public CustomHeaderCloseableHttpAsyncClient(
        final CloseableHttpAsyncClient client,
        final Header... headers)
    {
        this(client, Arrays.asList(headers));
    }

    public CustomHeaderCloseableHttpAsyncClient(
        final CloseableHttpAsyncClient client,
        final List<Header> headers)
    {
        super(client);
        this.headers = headers;
    }

    // CSOFF: ParameterNumber
    @Override
    public <T> Future<T> execute(
        final HttpAsyncRequestProducer requestProducer,
        final HttpAsyncResponseConsumer<T> responseConsumer,
        final HttpContext context,
        final FutureCallback<T> callback)
    {
        return super.execute(
            new HeaderAsyncRequestProducer(requestProducer, headers),
            responseConsumer,
            context,
            callback);
    }
    // CSON: ParameterNumber
}

