package ru.yandex.http.util.nio.client;

import ru.yandex.util.timesource.TimeSource;

public class DeadlineRetryContext<T> extends FilterRetryContext<T> {
    private final long deadline;

    public DeadlineRetryContext(
        final RetryContext<T> context,
        final long deadline)
    {
        super(context);
        this.deadline = deadline;
    }

    @Override
    public long nextRetryInterval(final Exception e) {
        long interval = super.nextRetryInterval(e);
        if (interval != -1L
            && TimeSource.INSTANCE.currentTimeMillis() + interval >= deadline)
        {
            return -1L;
        } else {
            return interval;
        }
    }
}

