package ru.yandex.http.util.nio.client;

import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;

public class DuplexRequestObserver implements RequestObserver {
    private final RequestObserver first;
    private final RequestObserver second;

    public DuplexRequestObserver(
        final RequestObserver first,
        final RequestObserver second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void notify(final HttpRoute route, final HttpRequest request) {
        first.notify(route, request);
        second.notify(route, request);
    }
}

