package ru.yandex.http.util.nio.client;

import java.util.function.BiFunction;

import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.EmptyFutureCallback;

public enum EmptyRequestsListener implements RequestsListener {
    INSTANCE;

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public long totalTime() {
        return 0L;
    }

    @Override
    public String details() {
        return "";
    }

    @Override
    public <T> FutureCallback<T> createCallbackFor(
        final HttpRoute route,
        final HttpRequest request,
        final HttpContext context)
    {
        return EmptyFutureCallback.instance();
    }

    @Override
    public <T> FutureCallback<T> createCallbackFor(
        final HttpRoute route,
        final String request,
        final BiFunction<RequestData, ? super T, RequestInfo> responseConverter)
    {
        return EmptyFutureCallback.instance();
    }
}

