package ru.yandex.http.util.nio.client;

import java.util.concurrent.Future;
import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class FailoverRetryContext<T> extends MultiTargetRetryContextBase<T> {
    private final Function<
        ? super HttpHost,
        ? extends HttpAsyncRequestProducer>
        producerFactory;

    public FailoverRetryContext(
        final MultiTargetRequestContext<T> context,
        final Function<? super HttpHost, ? extends HttpAsyncRequestProducer>
        producerFactory)
    {
        super(context);
        this.producerFactory = producerFactory;
    }

    @Override
    protected Future<T> sendRequest(
        final HttpHost host,
        final FutureCallback<T> callback)
    {
        return requestContext.sendRequest(
            producerFactory.apply(host),
            requestContext.contextSupplier().get(),
            callback);
    }
}

